/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.workbench.commands;

import com.aptana.core.logging.IdeLog;
import com.aptana.core.resources.IProjectContext;
import com.aptana.core.util.IOUtil;
import com.aptana.core.util.ProcessRunner;
import com.aptana.git.core.model.GitExecutable;
import com.aptana.scripting.model.BundleElement;
import com.aptana.scripting.model.BundleManager;
import com.aptana.scripting.model.BundlePrecedence;
import com.aptana.workbench.WorkbenchPlugin;
import com.aptana.workbench.commands.Messages;
import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.ui.IViewReference;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class EditBundleJob
extends Job {
    private BundleElement bundle;

    public EditBundleJob(BundleElement bundle) {
        super(MessageFormat.format(Messages.EditBundleJob_Name, bundle.getDisplayName()));
        this.bundle = bundle;
    }

    protected IStatus run(IProgressMonitor monitor) {
        if (this.bundle.getBundlePrecedence() == BundlePrecedence.PROJECT) {
            return Status.OK_STATUS;
        }
        try {
            SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
            IPath userBundlesDir = this.makeUserBundlesDirectory();
            subMonitor.worked(5);
            IPath destRuble = this.grabBundle(userBundlesDir);
            subMonitor.worked(75);
            this.createProjectIfNecessary(destRuble, (IProgressMonitor)subMonitor.newChild(20));
            subMonitor.done();
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
            return e.getStatus();
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)WorkbenchPlugin.getDefault(), (Throwable)e);
            return new Status(4, "com.aptana.workbench", e.getMessage(), (Throwable)e);
        }
        return Status.OK_STATUS;
    }

    protected IPath grabBundle(IPath destinationDir) throws CoreException {
        IPath destRuble = destinationDir.append(this.bundle.getBundleDirectory().getName());
        if (destRuble.toFile().isDirectory()) {
            IdeLog.logInfo((Plugin)WorkbenchPlugin.getDefault(), (String)("Trying to grab bundle, destination directory already exists: " + destRuble.toOSString()));
            return destRuble;
        }
        if (this.bundle.getRepository() == null) {
            this.copyIfPossible(destRuble);
        } else {
            this.grabCopyFromRepository(destinationDir, destRuble);
        }
        return destRuble;
    }

    protected IPath makeUserBundlesDirectory() throws CoreException {
        IPath userBundlesDir = Path.fromOSString((String)BundleManager.getInstance().getUserBundlesPath());
        if (userBundlesDir.toFile().isDirectory()) {
            return userBundlesDir;
        }
        if (userBundlesDir.toFile().mkdirs()) {
            return userBundlesDir;
        }
        throw new CoreException((IStatus)new Status(4, "com.aptana.scripting", Messages.EditBundleJob_CantCreateUserBundlesDir_Error));
    }

    protected void createProjectIfNecessary(IPath projectLocation, IProgressMonitor monitor) throws CoreException {
        SubMonitor subMonitor = SubMonitor.convert((IProgressMonitor)monitor, (int)100);
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject theProject = this.findMatchingProject(workspace, projectLocation);
        subMonitor.worked(10);
        boolean makeActive = true;
        if (theProject == null) {
            String projectName;
            int counter = 0;
            do {
                projectName = this.bundle.getDisplayName();
                if (counter > 0) {
                    projectName = String.valueOf(projectName) + counter;
                }
                ++counter;
            } while (this.projectExists(theProject = workspace.getRoot().getProject(projectName)));
            IProjectDescription description = workspace.newProjectDescription(theProject.getName());
            description.setLocation(projectLocation);
            theProject.create(description, (IProgressMonitor)subMonitor.newChild(45));
            theProject.open((IProgressMonitor)subMonitor.newChild(45));
            makeActive = false;
        }
        if (makeActive) {
            this.makeProjectActiveInAppExplorer(theProject);
        }
        subMonitor.done();
    }

    private boolean projectExists(IProject theProject) {
        IProject[] projects;
        if (theProject.exists()) {
            return true;
        }
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        IProject[] iProjectArray = projects = workspace.getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (project != null && theProject.getName().equalsIgnoreCase(project.getName())) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void makeProjectActiveInAppExplorer(final IProject theProject) {
        PlatformUI.getWorkbench().getDisplay().asyncExec(new Runnable(){

            public void run() {
                IViewReference[] refs;
                IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                IViewReference[] iViewReferenceArray = refs = window.getActivePage().getViewReferences();
                int n = refs.length;
                int n2 = 0;
                while (n2 < n) {
                    IViewReference ref = iViewReferenceArray[n2];
                    IWorkbenchPart part = ref.getPart(false);
                    if (part instanceof IProjectContext) {
                        IProjectContext projectContext = (IProjectContext)part;
                        projectContext.setActiveProject(theProject);
                        return;
                    }
                    ++n2;
                }
            }
        });
    }

    private void copyIfPossible(IPath destRuble) throws CoreException {
        if (this.bundle.getBundlePrecedence() != BundlePrecedence.APPLICATION) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.scripting", Messages.EditBundleJob_BundleHasNoRepository_Error));
        }
        try {
            IOUtil.copyDirectory((File)this.bundle.getBundleDirectory(), (File)destRuble.toFile());
        }
        catch (IOException e) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.scripting", e.getMessage(), (Throwable)e));
        }
    }

    private void grabCopyFromRepository(IPath workingDirectory, IPath destRuble) throws CoreException {
        String repoURI = this.bundle.getRepository();
        IStatus result = null;
        if (this.looksLikeGitURI(repoURI)) {
            if (GitExecutable.instance() == null) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.scripting", Messages.EditBundleJob_RequiresGitError));
            }
            result = GitExecutable.instance().runInBackground(workingDirectory, new String[]{"clone", repoURI, destRuble.toOSString()});
        } else if (this.looksLikeSVNURI(repoURI)) {
            result = new ProcessRunner().runInBackground(workingDirectory, new String[]{"svn", "checkout", repoURI, destRuble.toOSString()});
        } else {
            if (GitExecutable.instance() == null) {
                throw new CoreException((IStatus)new Status(4, "com.aptana.scripting", Messages.EditBundleJob_RequiresGitError));
            }
            result = GitExecutable.instance().runInBackground(workingDirectory, new String[]{"clone", repoURI, destRuble.toOSString()});
        }
        if (!result.isOK()) {
            throw new CoreException((IStatus)new Status(4, "com.aptana.scripting", String.valueOf(Messages.EditBundleJob_GitCloneFailed_Error) + result.getMessage()));
        }
    }

    protected IProject findMatchingProject(IWorkspace workspace, IPath dest) {
        IProject[] iProjectArray = workspace.getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            if (dest.equals((Object)project.getLocation())) {
                return project;
            }
            ++n2;
        }
        return null;
    }

    private boolean looksLikeSVNURI(String repoURI) {
        return repoURI.startsWith("svn:") || repoURI.startsWith("svn+") || repoURI.contains("/trunk") || repoURI.contains("/tags") || repoURI.contains("/branches");
    }

    private boolean looksLikeGitURI(String repoURI) {
        return repoURI.startsWith("git:") || repoURI.endsWith(".git") || repoURI.contains("github.com");
    }
}

